﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Linq;
using System.Text;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR
{
    public class DbUtil
    {
        public class AdvancedParam
        {
            public ParameterDirection? Direction { get; set; }
            public Object Value { get; set; }

            public AdvancedParam() { Direction = ParameterDirection.Input; }

            public AdvancedParam(ParameterDirection direction, Object value)
            {
                Direction = direction;
                Value = value;
            }

            public AdvancedParam(Object value)
            {
                Direction = ParameterDirection.Input;
                Value = value;
            }

            public AdvancedParam(ParameterDirection direction)
            {
                Direction = direction;
            }
        }

        public static string BurnPitConnectionString
        {
            get
            {
                return ConfigurationManager.ConnectionStrings["VeteransAffairs.Registries.Business.Properties.Settings.RegistryDALConnectionString"].ConnectionString;
            }
        }

        public static List<Object[]> ExecuteQuery(String stmt)
        {
            return ExecuteQuery(stmt, BurnPitConnectionString);
        }

        public static List<Object[]> ExecuteQuery(String stmt, String connectionString)
        {
            List<Object[]> results = new List<Object[]>();

            using (SqlConnection conn = new SqlConnection(connectionString))
            {
                using (SqlCommand command = new SqlCommand(stmt, conn))
                {
                    conn.Open();

                    using (SqlDataReader reader = command.ExecuteReader())
                    {
                        Object[] row;
                        while (reader.Read())
                        {
                            row = new Object[reader.FieldCount];
                            for (int i = 0; i < row.Length; i++)
                            {
                                row[i] = reader[i];
                            }
                            results.Add(row);
                        }
                    }
                }
            }
            return results;
        }

        public static List<Object[]> ExecuteQuery(String stmt, Dictionary<String, Object> paramDictionary)
        {
            return ExecuteQuery(stmt, paramDictionary, BurnPitConnectionString);
        }

        public static List<Object[]> ExecuteQuery(String stmt, Dictionary<String, Object> paramDictionary, String connectionString)
        {
            List<Object[]> results = new List<object[]>();

            using (SqlConnection conn = new SqlConnection(connectionString))
            {
                using (SqlCommand command = new SqlCommand(stmt, conn))
                {
                    conn.Open();
                    CreateParam(command, paramDictionary);
                    using (SqlDataReader reader = command.ExecuteReader())
                    {
                        Object[] row;
                        while (reader.Read())
                        {
                            row = new Object[reader.FieldCount];
                            for (int i = 0; i < row.Length; i++)
                            {
                                row[i] = reader[i];
                            }
                            results.Add(row);
                        }
                    }
                }
            }

            return results;
        }

        public static DataSet ExecuteQueryDataSet(String stmt, Dictionary<String, Object> paramDictionary)
        {
            return ExecuteQueryDataSet(stmt, paramDictionary, BurnPitConnectionString);
        }

        public static DataSet ExecuteQueryDataSet(String stmt, Dictionary<String, Object> paramDictionary, String connectionString)
        {
            DataSet ds = new DataSet();
            using (SqlConnection conn = new SqlConnection(connectionString))
            {
                using (SqlCommand command = new SqlCommand(stmt, conn))
                {
                    conn.Open();
                    CreateParam(command, paramDictionary);
                    using (SqlDataAdapter adapter = new SqlDataAdapter(command))
                    {
                        adapter.Fill(ds);
                    }
                    conn.Close();
                }
            }
            return ds;
        }

        public static string ExecuteQueryScalar(string stmt, Dictionary<string, string> paramDictionary)
        {
            return ExecuteQueryScalar(stmt, paramDictionary, BurnPitConnectionString);
        }

        public static string ExecuteQueryScalar(string stmt, Dictionary<string, string> paramDictionary, String connectionString)
        {
            string value = string.Empty;

            using (SqlConnection conn = new SqlConnection(connectionString))
            {
                using (SqlCommand command = new SqlCommand(stmt, conn))
                {
                    conn.Open();
                    CreateParam(command, paramDictionary);
                    object result = command.ExecuteScalar();
                    if (result != null)
                        value = result.ToString();
                }
            }

            return value;
        }

        public static string ExecuteQueryScalar(string stmt, Dictionary<string, string> paramDictionary, SqlConnection conn, SqlTransaction transaction)
        {
            string value = string.Empty;

            using (SqlCommand command = new SqlCommand(stmt, conn, transaction))
            {
                CreateParam(command, paramDictionary);
                object result = command.ExecuteScalar();
                if (result != null)
                    value = result.ToString();
            }

            return value;
        }

        public static int ExecuteInsert(String stmt, Dictionary<String, String> paramDictionary)
        {
            return ExecuteInsert(stmt, paramDictionary, BurnPitConnectionString);
        }

        public static int ExecuteInsert(String stmt, Dictionary<String, Object> paramDictionary)
        {
            return ExecuteInsert(stmt, paramDictionary, BurnPitConnectionString);
        }

        public static int ExecuteInsert(String stmt, Dictionary<String, Object> paramDictionary, String connectionString)
        {
            int result = 0;

            using (SqlConnection conn = new SqlConnection(connectionString))
            {
                using (SqlCommand command = new SqlCommand(stmt, conn))
                {
                    conn.Open();
                    CreateParam(command, paramDictionary);
                    result = command.ExecuteNonQuery();
                }
            }

            return result;
        }

        public static int ExecuteInsert(String stmt, Dictionary<String, Object> paramDictionary, SqlConnection conn, SqlTransaction transaction)
        {
            int result = 0;

            using (SqlCommand command = new SqlCommand(stmt, conn, transaction))
            {
                CreateParam(command, paramDictionary);
                result = command.ExecuteNonQuery();
            }
            return result;
        }

        public static int ExecuteInsert(String stmt, Dictionary<String, String> paramDictionary, String connectionString)
        {
            int result = 0;

            using (SqlConnection conn = new SqlConnection(connectionString))
            {
                using (SqlCommand command = new SqlCommand(stmt, conn))
                {
                    conn.Open();
                    CreateParam(command, paramDictionary);
                    result = command.ExecuteNonQuery();
                }
            }

            return result;
        }

        public static object ExecuteScalar(String stmt, Dictionary<String, Object> paramDictionary)
        {
            return ExecuteScalar(stmt, paramDictionary, BurnPitConnectionString);
        }

        public static object ExecuteScalar(String stmt, Dictionary<String, Object> paramDictionary, String connectionString)
        {
            object result = 0;

            using (SqlConnection conn = new SqlConnection(connectionString))
            {
                using (SqlCommand command = new SqlCommand(stmt, conn))
                {
                    conn.Open();
                    CreateParam(command, paramDictionary);
                    result = command.ExecuteScalar();
                }
            }

            return result;
        }

        public static object ExecuteSProcScalar(String stmt, Dictionary<String, Object> paramDictionary)
        {
            return ExecuteSProcScalar(stmt, paramDictionary, BurnPitConnectionString);
        }

        public static object ExecuteSProcScalar(String stmt, Dictionary<String, Object> paramDictionary, String connectionString)
        {
            object result = 0;

            using (SqlConnection conn = new SqlConnection(connectionString))
            {
                using (SqlCommand command = new SqlCommand(stmt, conn))
                {
                    conn.Open();
                    CreateParam(command, paramDictionary);
                    command.CommandType = CommandType.StoredProcedure;
                    result = command.ExecuteScalar();
                }
            }

            return result;
        }

        private static void CreateParam(SqlCommand command, Dictionary<String, String> paramDictionary)
        {
            foreach (KeyValuePair<string, string> param in paramDictionary)
            {
                SqlParameter newParam = new SqlParameter(param.Key, param.Value);

                command.Parameters.Add(newParam);
            }
        }

        private static void CreateParam(SqlCommand command, Dictionary<String, Object> paramDictionary)
        {
            foreach (KeyValuePair<String, Object> param in paramDictionary)
            {
                SqlParameter newParam = new SqlParameter(param.Key, param.Value);
                command.Parameters.Add(newParam);
            }
        }

        private static void CreateParam(SqlCommand command, Dictionary<String, AdvancedParam> paramDictionary)
        {
            foreach (KeyValuePair<String, AdvancedParam> param in paramDictionary)
            {
                var newParam = new SqlParameter();
                newParam.ParameterName = param.Key;
                newParam.Value = param.Value.Value;
                newParam.Direction = param.Value.Direction ?? ParameterDirection.Input;

                command.Parameters.Add(newParam);
            }
        }

        public static void ExecuteBulkInsert(String tableName, DataTable dataTable, List<SqlBulkCopyColumnMapping> columnMappings)
        {
            ExecuteBulkInsert(tableName, dataTable, columnMappings, BurnPitConnectionString);
        }

        public static void ExecuteBulkInsert(String tableName, DataTable dataTable, List<SqlBulkCopyColumnMapping> columnMappings, String connectionString)
        {
            using (SqlBulkCopy sbc = new SqlBulkCopy(connectionString))
            {
                sbc.DestinationTableName = tableName;
                sbc.BatchSize = 1;

                foreach (SqlBulkCopyColumnMapping m in columnMappings)
                {
                    sbc.ColumnMappings.Add(m);
                }

                sbc.WriteToServer(dataTable);
                sbc.Close();
            }
        }

        public static void ExecuteNonQuery(String stmt, Dictionary<String, Object> paramDictionary, SqlConnection conn, SqlTransaction transaction)
        {
            using (SqlCommand command = new SqlCommand(stmt, conn, transaction))
            {
                CreateParam(command, paramDictionary);
                command.ExecuteNonQuery();
            }
        }

        public static void ExecuteNonQuery(String stmt, Dictionary<String, Object> paramDictionary)
        {
            using (SqlConnection conn = new SqlConnection(BurnPitConnectionString))
            {
                using (SqlCommand command = new SqlCommand(stmt, conn))
                {
                    conn.Open();
                    CreateParam(command, paramDictionary);
                    command.ExecuteNonQuery();
                }
            }
        }

        public static void ExecuteSProcNonQuery(String stmt, Dictionary<String, Object> paramDictionary)
        {
            using (SqlConnection conn = new SqlConnection(BurnPitConnectionString))
            {
                using (SqlCommand command = new SqlCommand(stmt, conn))
                {
                    conn.Open();
                    CreateParam(command, paramDictionary);
                    command.CommandType = CommandType.StoredProcedure;
                    command.ExecuteNonQuery();
                }
            }
        }

        public static List<Object[]> ExecuteSProc(String stmt, Dictionary<String, AdvancedParam> paramDictionary)
        {
            return ExecuteSProc(stmt, paramDictionary, BurnPitConnectionString);
        }

        public static List<Object[]> ExecuteSProc(String stmt, Dictionary<String, AdvancedParam> paramDictionary,
            String connectionString)
        {
            var results = new List<object[]>();

            using (var conn = new SqlConnection(connectionString))
            {
                using (var command = new SqlCommand(stmt, conn))
                {
                    conn.Open();
                    CreateParam(command, paramDictionary);
                    command.CommandType = CommandType.StoredProcedure;
                    using (var reader = command.ExecuteReader())
                    {
                        // process any in/out or out parameters
                        foreach (SqlParameter param in command.Parameters)
                        {
                            if (param.Direction == ParameterDirection.InputOutput ||
                                param.Direction == ParameterDirection.Output)
                                paramDictionary[param.ParameterName].Value = param.Value;
                        }

                        while (reader.Read())
                        {
                            var row = new object[reader.FieldCount];
                            for (var i = 0; i < row.Length; i++)
                            {
                                row[i] = reader[i];
                            }
                            results.Add(row);
                        }
                    }
                }
            }

            return results;
        }

        public static List<Object[]> ExecuteSProc(String stmt, Dictionary<String, Object> paramDictionary, SqlConnection conn, SqlTransaction transaction)
        {
            List<Object[]> results = new List<object[]>();

            using (SqlCommand command = new SqlCommand(stmt, conn, transaction))
            {
                CreateParam(command, paramDictionary);
                command.CommandType = CommandType.StoredProcedure;
                using (SqlDataReader reader = command.ExecuteReader())
                {
                    Object[] row;
                    while (reader.Read())
                    {
                        row = new Object[reader.FieldCount];
                        for (int i = 0; i < row.Length; i++)
                        {
                            row[i] = reader[i];
                        }
                        results.Add(row);
                    }
                }
            }

            return results;
        }

        public static List<Object[]> ExecuteSProc(String stmt, Dictionary<String, Object> paramDictionary)
        {
            return ExecuteSProc(stmt, paramDictionary, BurnPitConnectionString);
        }

        public static List<Object[]> ExecuteSProc(String stmt, Dictionary<String, Object> paramDictionary, String connectionString)
        {
            List<Object[]> results = new List<object[]>();

            using (SqlConnection conn = new SqlConnection(connectionString))
            {
                using (SqlCommand command = new SqlCommand(stmt, conn))
                {
                    conn.Open();
                    CreateParam(command, paramDictionary);
                    command.CommandType = CommandType.StoredProcedure;
                    using (SqlDataReader reader = command.ExecuteReader())
                    {
                        Object[] row;
                        while (reader.Read())
                        {
                            row = new Object[reader.FieldCount];
                            for (int i = 0; i < row.Length; i++)
                            {
                                row[i] = reader[i];
                            }
                            results.Add(row);
                        }
                    }
                }
            }

            return results;
        }
        public static DataSet ExecuteSProcDataSet(String stmt, Dictionary<String, Object> paramDictionary)
        {
            return ExecuteSProcDataSet(stmt, paramDictionary, BurnPitConnectionString);
        }
        public static DataSet ExecuteSProcDataSet(String stmt, Dictionary<String, Object> paramDictionary, String connectionString)
        {
            DataSet ds = new DataSet();

            using (SqlConnection conn = new SqlConnection(connectionString))
            {
                using (SqlCommand command = new SqlCommand(stmt, conn))
                {
                    conn.Open();
                    CreateParam(command, paramDictionary);
                    command.CommandType = CommandType.StoredProcedure;
                    using (SqlDataAdapter adapter = new SqlDataAdapter(command))
                    {
                        adapter.Fill(ds);
                    }
                }
            }

            return ds;
        }
    }
}
